 /*********************************************************************
 *
 *                  Radio Utility Driver specific defs.
 *
 *********************************************************************
 * FileName:        RadioDriverdefs.h
 * Dependencies:    None
 * Processor:       PIC18/PIC24
 * Complier:        MCC18 v1.00.50 or higher, C30 3.10 or higher
 *                  HITECH PICC-18 V8.10PL1 or higher
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company.
 *
 * The software is owned by the Company and/or its supplier, and is
 * protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *****************************************************************************/

//application specific (for demo purposes only)
#define BAUD_RATE 19200
	//Baud rate is set to 19200 for communication through UART
#define REV1
	//INT mapping modified from REV A0 to REV1 (INTO to INT1)
	//newer modules are REV1s

//IEEE EUI - globally unique number
#define EUI_7 0x00
#define EUI_6 0x01
#define EUI_5 0x02
#define EUI_4 0x03
#define EUI_3 0x04
#define EUI_2 0x05
#define EUI_1 0x06
#define EUI_0 0x07

//MRF24J40 Reset, Wake, INT, CS pin mappings and LED port connections for each demo board
#if defined(__18F4620) || defined(__18F87J11)
        
    #if defined(__18F4620)  // PICDEM Z board defines
        #define CLOCK_FREQ 16000000
        // Transceiver Configuration
        #define RFIF INT0IF
        #define RFIE INT0IE
        #define PHY_CS LATC0
        #define PHY_CS_TRIS TRISC0
        #define PHY_RESETn LATC2
        #define PHY_RESETn_TRIS TRISC2
        #define PHY_WAKE LATC1
        #define PHY_WAKE_TRIS TRISC1
		#define LED_1 LATA0
    	#define LED_2 LATA1
    	#define LED_1_TRIS TRISA0
    	#define LED_2_TRIS TRISA1
		#define RF_INT_PIN RB0
	#elif defined (__18F87J11) //PIC18 Explorer board defines
		#if defined REV1
		#define CLOCK_FREQ 10000000
        // Transceiver Configuration
        #define RFIF INTCON3bits.INT1IF
        #define RFIE INTCON3bits.INT1IE
        #define PHY_CS LATB3
        #define PHY_CS_TRIS TRISB3
        #define PHY_RESETn LATB5
        #define PHY_RESETn_TRIS TRISB5
        #define PHY_WAKE LATB4
        #define PHY_WAKE_TRIS TRISB4
		#define LED_1 LATD0
    	#define LED_2 LATD1
    	#define LED_1_TRIS TRISD0
    	#define LED_2_TRIS TRISD1
		#define RF_INT_PIN RB1
		#else
		#define CLOCK_FREQ 10000000
        // Transceiver Configuration
        #define RFIF INT0IF
        #define RFIE INT0IE
        #define PHY_CS LATB3
        #define PHY_CS_TRIS TRISB3
        #define PHY_RESETn LATB5
        #define PHY_RESETn_TRIS TRISB5
        #define PHY_WAKE LATB4
        #define PHY_WAKE_TRIS TRISB4
		#define LED_1 LATD0
    	#define LED_2 LATD1
    	#define LED_1_TRIS TRISD0
    	#define LED_2_TRIS TRISD1
    	#define RF_INT_PIN RB0
		#endif
    #endif

#else			// Explorer 16 board defines
    #define CLOCK_FREQ 8000000
    #define RFIF IFS1bits.INT1IF
    #define RFIE IEC1bits.INT1IE
    #define RF_INT_PIN PORTEbits.RE8
    #define PHY_CS LATBbits.LATB2
    #define PHY_CS_TRIS TRISBbits.TRISB2
    #define PHY_RESETn LATGbits.LATG2
    #define PHY_RESETn_TRIS TRISGbits.TRISG2
    #define PHY_WAKE LATGbits.LATG3
    #define PHY_WAKE_TRIS TRISGbits.TRISG3
    
    #define LED_1 LATAbits.LATA7
    #define LED_2 LATAbits.LATA6
    #define LED_1_TRIS TRISAbits.TRISA7
    #define LED_2_TRIS TRISAbits.TRISA6

#endif

